/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.charSelect;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.DailyMods;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.metrics.LeaderboardPoster;
import com.megacrit.cardcrawl.screens.charSelect.CharacterOption;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.screens.mainMenu.MenuCancelButton;
import com.megacrit.cardcrawl.ui.buttons.ConfirmButton;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import java.util.Random;

public class CharacterSelectScreen {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("CharacterSelectScreen");
    public static final String[] TEXT = CharacterSelectScreen.uiStrings.TEXT;
    private static final String CHOOSE_CHAR_MSG = TEXT[0];
    public ConfirmButton confirmButton = new ConfirmButton(TEXT[1]);
    public MenuCancelButton cancelButton = new MenuCancelButton();
    private ArrayList<CharacterOption> options = new ArrayList();
    private boolean anySelected = false;
    public Texture bgCharImg = null;
    private Color bgCharColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private static final float BG_Y_OFFSET_TARGET = 100.0f * Settings.scale;
    private float bg_y_offset = BG_Y_OFFSET_TARGET / 2.0f;

    public void initialize() {
        this.options.add(new CharacterOption(TEXT[2], AbstractPlayer.PlayerClass.IRONCLAD, "ironcladButton.png", "ironcladPortrait.jpg"));
        if (!UnlockTracker.isCharacterLocked("The Silent")) {
            this.options.add(new CharacterOption(TEXT[3], AbstractPlayer.PlayerClass.THE_SILENT, "silentButton.png", "silentPortrait.jpg"));
        } else {
            this.options.add(new CharacterOption(AbstractPlayer.PlayerClass.THE_SILENT));
        }
        this.options.add(new CharacterOption(AbstractPlayer.PlayerClass.CROWBOT));
        this.positionButtons();
    }

    private void positionButtons() {
        int count = this.options.size();
        float offsetX = (float)Settings.WIDTH / 2.0f - (float)(count / 2) * 220.0f * Settings.scale;
        for (int i = 0; i < count; ++i) {
            this.options.get(i).move(offsetX + (float)i * 220.0f * Settings.scale, 190.0f * Settings.scale);
        }
    }

    public void open() {
        this.cancelButton.show(TEXT[5]);
        CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.CHAR_SELECT;
        CardCrawlGame.mainMenuScreen.darken();
    }

    public void update() {
        this.anySelected = false;
        for (CharacterOption o : this.options) {
            o.update();
            if (!o.selected) continue;
            this.anySelected = true;
        }
        this.updateButtons();
        if (InputHelper.justReleasedClickLeft && !this.anySelected) {
            this.confirmButton.isDisabled = true;
            this.confirmButton.hide();
        }
        if (this.anySelected) {
            this.bgCharColor.a = MathHelper.fadeLerpSnap(this.bgCharColor.a, 1.0f);
            this.bg_y_offset = MathHelper.fadeLerpSnap(this.bg_y_offset, -BG_Y_OFFSET_TARGET / 2.0f);
        } else {
            this.bgCharColor.a = MathHelper.fadeLerpSnap(this.bgCharColor.a, 0.0f);
        }
    }

    public void justSelected() {
        this.bg_y_offset = BG_Y_OFFSET_TARGET / 2.0f;
    }

    public void updateButtons() {
        this.cancelButton.update();
        this.confirmButton.update();
        if (this.cancelButton.hb.clicked || InputHelper.pressedEscape) {
            InputHelper.pressedEscape = false;
            this.cancelButton.hb.clicked = false;
            CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.MAIN_MENU;
            CardCrawlGame.mainMenuScreen.lighten();
            this.cancelButton.hide();
            for (CharacterOption o : this.options) {
                o.selected = false;
            }
            this.bgCharColor.a = 0.0f;
            this.anySelected = false;
        }
        if (this.confirmButton.hitbox.clicked) {
            this.confirmButton.hitbox.clicked = false;
            this.confirmButton.isDisabled = true;
            this.confirmButton.hide();
            CardCrawlGame.mainMenuScreen.isFadingOut = true;
            CardCrawlGame.mainMenuScreen.fadeOutMusic();
            Settings.seed = new Random().nextLong();
            Settings.isDailyRun = false;
            Settings.isTrial = false;
            DailyMods.setModsFalse();
            AbstractDungeon.generateSeeds();
            this.confirmButton.hitbox.clicked = false;
            this.confirmButton.hide();
            if (Settings.isDemo || Settings.isPublisherBuild) {
                LeaderboardPoster poster = new LeaderboardPoster();
                poster.setValues(LeaderboardPoster.LeaderboardDataType.DEMO_EMBARK, null, null, null, false);
                Thread t = new Thread(poster);
                t.run();
            }
        }
    }

    public void render(SpriteBatch sb) {
        sb.setColor(this.bgCharColor);
        if (this.bgCharImg != null) {
            if (Settings.isSixteenByTen) {
                sb.draw(this.bgCharImg, (float)Settings.WIDTH / 2.0f - 960.0f, (float)Settings.HEIGHT / 2.0f - 600.0f, 960.0f, 600.0f, 1920.0f, 1200.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1920, 1200, false, false);
            } else {
                sb.draw(this.bgCharImg, (float)Settings.WIDTH / 2.0f - 960.0f, (float)Settings.HEIGHT / 2.0f - 600.0f + this.bg_y_offset, 960.0f, 600.0f, 1920.0f, 1200.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1920, 1200, false, false);
            }
        }
        this.cancelButton.render(sb);
        this.confirmButton.render(sb);
        boolean anythingSelected = false;
        for (CharacterOption o : this.options) {
            if (o.selected) {
                anythingSelected = true;
            }
            o.render(sb);
        }
        if (!anythingSelected) {
            FontHelper.renderFontCentered(sb, FontHelper.bannerFont, CHOOSE_CHAR_MSG, (float)Settings.WIDTH / 2.0f, 340.0f * Settings.scale, Settings.CREAM_COLOR);
        }
    }

    public void deselectOtherOptions(CharacterOption characterOption) {
        for (CharacterOption o : this.options) {
            if (o == characterOption) continue;
            o.selected = false;
        }
    }
}

